function [r,tau,phir,phitau]=factrtau(obj)
% FACTRTAU retourne les facteurs de rflexion et de transmission en
%   termes de fonctions d'onde pour un objet physique interagissant avec une
%   marche d'nergie potentielle. Les phases de ces facteurs sont
%   galement donnes entre 0 et 2*pi.
%   [r,tau,phir,phitau]=FACTRTAU(obj)
%       >> obj      = objet informatique marche;
%       << r        = facteur de rflexion;
%       << tau      = facteur de transmission;
%       << phir     = phase  la rflexion;
%       << phitau   = phase  la transmission.
%
%   Olivier Pujol : septembre 2013
%
%
%% Vrifications

if (isa(obj,'marche')==0),error('Mauvais type d''objet !');end
if (obj.ke==0),error('Cas singulier k=0 !');end

%% Matrice de rflexion-rfraction de la marche 

mat=matrix(obj);

%% Calcul des facteurs de r et tau

r=-mat(2,1)/mat(2,2);
tau=sqrt(obj.ke/obj.ks)*(1/mat(2,2));
%
phir=mod(angle(r),pi);
phitau=mod(angle(tau),pi);
%
return;